# Gitbull

GitBull is an application developed at TU Delft as part of the 2023/2024 edition of the Software Project course. It provides management and monitoring of GitLab repositories for educational use. Course staff can easily access overviews of their course editions, make modifications to them, import groups of students, set up their repositories and monitor their performance through Git analysis tools.

## Development Team - AREAS

| Picture | Name | Email |
|---|---|---|
| <a href=""><img src="https://i.imgur.com/Jvle8ws.png" border="0" height=60></a> | Albert Alexandru Sandu | A.A.Sandu@student.tudelft.nl|
| <a href=""><img src="https://i.imgur.com/dCH9k5K.png" border="0" height=60></a> | Radu Stefan Ezaru | Ezaru@student.tudelft.nl|
| <a href=""><img src="https://i.imgur.com/fCfwCet.png" border="0" height=60></a> | Elena Uleia | E.Uleia@student.tudelft.nl|
| <a href=""><img src="https://i.imgur.com/NQo9401.png" border="0" height=60></a> | Ana Cristiana Marcu | A.C.Marcu-1@student.tudelft.nl|
| <a href=""><img src="https://i.imgur.com/C5dsuGs.png" border="0" height=60></a> | Serban Alexandru Ungureanu | Ungureanu-2@student.tudelft.nl|

## Requirements

- [GitLab SaaS or Self-hosted](https://about.gitlab.com)
- Java 17+
- [Gradle 7.0+](https://gradle.org/releases/)
- Linux or [WSL 2+](https://learn.microsoft.com/en-us/windows/wsl/install) if you're using Windows
- [Python](https://www.python.org/downloads/)
- Local clone of [Labracore](https://gitlab.ewi.tudelft.nl/eip/labrador/labracore)
- Local clone of the [GitBull frontend server](https://gitlab.ewi.tudelft.nl/cse2000-software-project/2022-2023-q4/cluster-14/14a-gitlab-management-for-educational-use/14a-frontend)

## Installation

You may clone the project through [git](https://git-scm.com).
Follow the instructions on how to install and configure Labracore from its repository.

* You will also need to set the `gitbull.statistics.gitlab-url`. It defaults to `https://courses.ewi.tudelft.nl/gitlab`. Make sure to always include the `https://`.
* You will also need to provide a username and a key for the user that will run the statistics. This account needs to have admin access, and the key requires all `read_` features.
  * For developers who are part of team AREAS, check the bottom of the **SP-GITLAB** master document, where you will find a username and key. 


## Setting up GitBull

After cloning the project, you will need to navigate to `/src/main/resources/` and rename the `application.properties.template` file to `application.properties`.

Change variables to match your GitLab instance URL, your personal access token with the `api` scope (for operations done by the application itself, mainly scheduling of reports), GitBull frontend application secret, Labracore clone secret and others.

## Statistics

By default, the external statistics module ([Geit](https://github.com/kelhaji/geit) for now) is disabled. The statistics module requires use of a Linux machine, or a Windows machine with [WSL](https://aka.ms/wsl) installed. 

To enable the module, navigate to `application.properties`.

* In order to perform the Geit installation, set `gitbull.statistics.install-statistics` to `true`. 
* For any script analysis to actually run, you also need to set `gitbull.statistics.enable-scheduler` to `true`. By default, it will run every minute. To change this behavior, head to the `statistics.StatisticsScheduler` class, where instructions on changing the scheduling can be easily found (including some preset values).

## Setting up Labracore

You must add the users you want to be part of GitBull as well in the application's database. See `DevDatabaseLoader` and `ProdDatabaseLoader` in Labracore.
Further information about Labracore can be found [here](https://gitlab.ewi.tudelft.nl/groups/eip/labrador/-/wikis/home).

## Running the project

The GitBull backend, frontend, Labracore and GitLab instance must all run for the system to function correctly.

You may build and run the GitBull backend server or Labracore through an IDE such as [IntelliJ](https://www.jetbrains.com/idea/) or the console command `./gradlew build bootRun`.

You may run the GitBull frontend through the line console command `npm run dev`.

## Further information

Read [For developers](https://gitlab.ewi.tudelft.nl/cse2000-software-project/2022-2023-q4/cluster-14/14a-gitlab-management-for-educational-use/14a-code/-/wikis/For-Developers) for more information about aspects of the project, especially application properties.
