import com.diffplug.gradle.spotless.SpotlessExtension

group = "nl.tudelft"
version = "0.1"

val libradorVersion = "1.2.0"
val labradoorVersion = "1.3.5"

val springDocVersion = "1.2.33"
val lombokVersion = "1.18.18"
val hibernateJpaVersion = "1.0.2.Final"

val javaVersion = JavaVersion.VERSION_17

plugins {
	// Plugin for the Kotlin-DSL to be on classpath, disabled
	// because it does not need to be applied during build.
	`kotlin-dsl` apply false

	// Standard plugins for Gradle to work properly
	java
	idea
	jacoco
	eclipse


	// Code style
	id("com.diffplug.spotless").version("6.0.1")


	// Pitest
	id("info.solidsoft.pitest").version("1.9.0")

	// Spring plugins for managing dependencies and creating
	// a nice Spring Boot application.
	id("org.springframework.boot").version("2.5.14")
	id("io.spring.dependency-management").version("1.0.11.RELEASE")
}

//checkstyle {
//	toolVersion = "10.3.2"
//	isIgnoreFailures = false
//	maxWarnings = 0
//	maxErrors = 0
//}

repositories {
	mavenLocal()
	mavenCentral()

	maven {
		url = uri("https://build.shibboleth.net/nexus/content/repositories/releases")
	}
	maven {
		name = "GitLab Librador repository"
		url = uri("https://gitlab.ewi.tudelft.nl/api/v4/projects/3634/packages/maven")
	}
	maven {
		name = "GitLab Labradoor repository"
		url = uri("https://gitlab.ewi.tudelft.nl/api/v4/projects/3611/packages/maven")
	}
}

java {
	sourceCompatibility = javaVersion
	targetCompatibility = javaVersion
}

sourceSets {
	main {}

	test {}
}

tasks.withType<Test>().configureEach {
	useJUnitPlatform()
	minHeapSize = "256m"
	maxHeapSize = "1024m"

	testLogging {
		// Turn this on when needing to debug gradle test runs
		showStandardStreams = false
	}
}

dependencies {
	// Spring
	implementation("org.springframework.boot:spring-boot-starter")
	implementation("org.springframework.boot:spring-boot-starter-data-jpa")
	implementation("org.springframework.boot:spring-boot-starter-data-rest")
	implementation("org.springframework.boot:spring-boot-starter-mail")
	implementation("org.springframework.boot:spring-boot-starter-web")
	implementation("org.springframework.boot:spring-boot-starter-websocket")
	implementation("org.springframework.boot:spring-boot-starter-webflux")
	implementation("org.springframework.boot:spring-boot-starter-validation")

	// Hibernate for database-entity mapping and EntityManagers
	//implementation("org.hibernate.orm:hibernate-core:6.2.2.Final")
	//implementation("org.hibernate.orm:hibernate-java8:6.0.0.Alpha7")
	//implementation("org.hibernate:hibernate-entitymanager:5.6.15.Final")
	implementation("org.hibernate:hibernate-entitymanager:5.4.33.Final")
	implementation("org.hibernate:hibernate-core:5.4.33.Final")
	implementation("org.hibernate:hibernate-java8:5.4.33.Final")

	// Dependencies for enabling Spring security + SAML security in Spring
	implementation("org.springframework.boot:spring-boot-starter-security")

	// Labrador project dependencies
   implementation("nl.tudelft.labrador:librador:$libradorVersion") {
        exclude("org.springframework.boot:spring-boot-starter-data-rest")
    }
    implementation("nl.tudelft.labrador:labradoor:$labradoorVersion")

	// Test dependencies
	testImplementation("org.springframework.boot:spring-boot-starter-test")
	//testImplementation("org.springframework.security:spring-security-test")

	// Spring properties
	implementation("org.springframework.boot:spring-boot-configuration-processor")
	annotationProcessor("org.springframework.boot:spring-boot-configuration-processor")

	// Sentry for writing error logs to a server for developer access
	implementation("io.sentry:sentry-spring-boot-starter:5.1.1")
	implementation("io.sentry:sentry-logback:5.1.1")

	// Dependency for mapping one data class to another
	implementation("org.modelmapper:modelmapper:2.3.6")

	// Database
	implementation("com.h2database:h2")

	// GitLab API
	implementation("org.gitlab4j:gitlab4j-api:5.0.1")
	implementation("javax.ws.rs:javax.ws.rs-api:2.1.1")
	implementation("javax.persistence:javax.persistence-api:2.2")
	implementation("javax.annotation:javax.annotation-api:1.3.2")
	//implementation("jakarta.ws.rs:jakarta.ws.rs-api:2.1.6")
	//implementation("jakarta.persistence:jakarta.persistence-api:2.2.3")
	//implementation("jakarta.annotation:jakarta.annotation-api:2.1.1")

	// Support for env files
	implementation("io.github.cdimascio:dotenv-java:3.0.0")

	// Thymeleaf for in-memory SSO
	implementation("org.springframework.boot:spring-boot-starter-thymeleaf")

	// Apache Commons
	implementation("org.apache.commons:commons-csv:1.10.0")

	// Cron4j scheduler library
	implementation("it.sauronsoftware.cron4j:cron4j:2.2.5")

	// Annotation procs
	//annotationProcessor("javax.annotation:javax.annotation-api")
	//annotationProcessor("org.hibernate.javax.persistence:hibernate-jpa-2.1-api:$hibernateJpaVersion")

	// Lombok
	compileOnly("org.projectlombok:lombok:1.18.26")
	testCompileOnly("org.projectlombok:lombok:1.18.26")
	annotationProcessor("org.projectlombok:lombok:1.18.26")
	testAnnotationProcessor("org.projectlombok:lombok:1.18.26")

	// Mockito
	testImplementation("org.mockito:mockito-junit-jupiter:5.2.0")
}

configure<SpotlessExtension> {
	java {
		// Add formatter and import order
		eclipse().configFile(file("eclipse-formatter.xml"))
		importOrderFile(file("$rootDir/import-order.txt"))

		// Default rules
		removeUnusedImports()
		trimTrailingWhitespace()
		endWithNewline()
	}
}

tasks.test {
	finalizedBy(tasks.jacocoTestReport) // report is always generated after tests run
}

configure<JacocoPluginExtension> {
	toolVersion = "0.8.7"
}


tasks.jacocoTestReport {
	dependsOn(tasks.test) // tests are required to run before generating the report

	classDirectories.setFrom(
		files(classDirectories.files.map {
			fileTree(it) {
				exclude(
					"**/config/**",
					"**/entity/**",
				)
			}
		})
	)

	group = "Reporting"
	reports {
		xml.required.set(true)
		csv.required.set(true)

		html.outputLocation.set(file("$buildDir/reports/coverage"))
	}
}


/*
pitest {
	junit5PluginVersion = '0.12'

	targetClasses = ['areas.gitbull.*']
	threads = 4
	outputFormats = ['XML', 'HTML']
	timestampedReports = false
}
*/