package server;

import java.io.IOException;
import java.util.concurrent.Executor;

import nl.tudelft.labracore.lib.LabracoreApiConfig;
import nl.tudelft.librador.EnableLibrador;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/**
 * GitBull main...
 */
@SpringBootApplication(scanBasePackageClasses = Main.class)
@EnableLibrador
@Import(LabracoreApiConfig.class)
@EnableAsync
public class Main {
	public static void main(String[] args) throws IOException {
		SpringApplication.run(Main.class, args);
	}

	@Bean
	public Executor taskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		executor.setCorePoolSize(3);
		executor.setMaxPoolSize(6);
		executor.setQueueCapacity(500);
		executor.setThreadNamePrefix("Worker- ");
		executor.initialize();
		return executor;
	}
}
