package server.config;

import org.gitlab4j.api.GitLabApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppConfig {

	@Value("${GITLAB_SERVER_URL}")
	String serverUrl;

	@Value("glpat-XbzkoyqxGAqiyQx343Nt")
	String accessToken;

	@Bean
	public GitLabApi rootGitLabAPI() {
		return new GitLabApi(serverUrl, accessToken);
	}
}
