package server.config;

import nl.tudelft.labracore.lib.security.LabradorSecurityConfigurerAdapter;

import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;

// This tells Spring to use this config by default for tests
@SpringBootConfiguration
@Profile("!production")
public class DevSecurityConfig extends LabradorSecurityConfigurerAdapter {

	//	@Override
	//	protected void configure(HttpSecurity http) throws Exception {
	//		super.configure(http);
	//
//		//@formatter:off
//        http
//            .authorizeRequests()
//            // Production permissions
//            .requestMatchers(new AntPathRequestMatcher("/")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/manifest.json")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/favicon.ico")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/sw.js")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/css/**")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/font/**")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/sass/**")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/img/**")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/js/**")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/webjars/**")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/stomp/**")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/lab/submit*")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/privacy")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/about")).permitAll()
//			.requestMatchers(new AntPathRequestMatcher("/api/frontend")).permitAll()
//            .requestMatchers(new AntPathRequestMatcher("/api/gitlab/createCourse")).permitAll()
//				.requestMatchers(new AntPathRequestMatcher("/api/group/getGroups")).permitAll()
//				.requestMatchers(new AntPathRequestMatcher("/api/frontend/getAuthUserName")).permitAll()
//				.requestMatchers(new AntPathRequestMatcher("/api/frontend/checkConnection")).permitAll()
//				.requestMatchers(new AntPathRequestMatcher("/api/gitlab/setup")).permitAll()
//
//
//            // Development specific permitted pages
//            .requestMatchers(new AntPathRequestMatcher("/h2-console/**")).permitAll()
//            .anyRequest()
//            .authenticated();
//
//        http.csrf().ignoringRequestMatchers(new AntPathRequestMatcher("/h2-console/**"));
//        http.headers().frameOptions().disable();
        //@formatter:on

	@Override
	protected void configure(HttpSecurity http) throws Exception {
		super.configure(http);
		http.authorizeRequests().anyRequest().permitAll();
		http.cors().and().csrf().disable();
	}
}
