package server.config;

import nl.tudelft.labracore.lib.security.LabradorSecurityConfigurerAdapter;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

@Configuration
@Profile("production")
public class ProductionSecurityConfig extends LabradorSecurityConfigurerAdapter {
	@Override
	protected void configure(HttpSecurity http) throws Exception {
		super.configure(http);

		//@formatter:off
        http
            .authorizeRequests()
            .requestMatchers(new AntPathRequestMatcher("/")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/manifest.json")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/favicon.ico")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/sw.js")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/css/**")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/font/**")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/sass/**")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/img/**")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/js/**")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/webjars/**")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/stomp/**")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/lab/submit*")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/privacy")).permitAll()
            .requestMatchers(new AntPathRequestMatcher("/about")).permitAll()
            .anyRequest()
            .authenticated();

        http.exceptionHandling().accessDeniedPage("/error");
        //@formatter:on
	}
}
