package server.csvconverter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.stereotype.Service;

/**
 * Service that validates student emails.
 */
@Service
public class StudentEmailValidator {
	/**
	 * The pattern of a student email.
	 */
	private final String STUDENT_EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@student.tudelft.nl";

	/**
	 * Checks whether a given email matches the desired student email pattern.
	 *
	 * @param  email the email that needs to be validated.
	 * @return
	 */
	public boolean validate(final String email) {
		Pattern pattern = Pattern.compile(STUDENT_EMAIL_PATTERN);
		Matcher matcher = pattern.matcher(email);
		return matcher.matches();
	}
}
