package server.entity;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Access entity representing the priorities for access an account has for a specific group and course.
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class Access {

	/**
	 * Unique ID generated automatically for the specific set of access rule.
	 */
	@Id
	@GeneratedValue
	private long accessID;

	/**
	 * Group ID for which the user has the role for.
	 */
	private long groupID;

	/**
	 * The account ID representing the user with the assigned role.
	 */
	private String accountID;

	/**
	 * Encoded integer representing the role the user has.
	 */
	private int role;

	/**
	 * CourseEdition ID for which the user has the role for.
	 */
	private long courseEditionID;

	/**
	 * LocalDateTime object corresponding to the time the entry was created.
	 */
	private LocalDateTime timeCreated;

	/**
	 * LocalDateTime object corresponding to the time the entry was last modified.
	 */
	private LocalDateTime lastModified;
}
