package server.entity;

import java.time.LocalDateTime;

import javax.persistence.*;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Account entity representing an account, storing the user ID and the apikey for eah user.
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class Account {

	/**
	 * NetId of the user's account.
	 */
	@Id
	private String netId;

	/**
	 * Unique ID of the user's account.
	 */
	private String userId;

	/**
	 * Api Key assigned to the user's account.
	 */
	private String apiKey;

	/**
	 * Email assigned to the user's account.
	 */
	private String email;

	/**
	 * String representing full name assigned to the user's account.
	 */
	private String name;

	/**
	 * LocalDateTime object corresponding to the time the entry was created.
	 */
	private LocalDateTime timeCreated;

	/**
	 * LocalDateTime object corresponding to the time the entry was last modified.
	 */
	private LocalDateTime lastModified;

	public Account(String userId, String email) {
		this.userId = userId;
		this.email = email.toLowerCase();
	}

	public Account(String userId, String email, String netId) {
		this.userId = userId;
		this.email = email;
		this.netId = netId.toLowerCase();
	}

	/**
	 * Constructor for an account using an email as well. Makes the email lowercase in order to be compatible
	 * with the email checker in the gitlab4j library.
	 *
	 * @param userId User ID. Represents the student number for imported users
	 * @param email  Email of the user
	 * @param netId  NetID of the user
	 * @param name   Full name of the user
	 */
	public Account(String userId, String email, String netId, String name) {
		this.userId = userId;
		this.email = email.toLowerCase();
		this.netId = netId;
		this.name = name;
	}
}
