package server.entity;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * CourseEdition entity representing details of a specific course edition and name of it.
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CourseEdition {

	/**
	 * Unique ID generated automatically.
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private long courseEditionID;

	/**
	 * The name of the course.
	 */
	private String courseName;

	/**
	 * The edition of the course.
	 */
	private String edition;

	/**
	 * Variable representing the path (GitLab path) for the edition represented by the entry in the database.
	 */
	private String coursePath;

	/**
	 * LocalDateTime object corresponding to the time the entry was created.
	 */
	private LocalDateTime timeCreated;

	/**
	 * LocalDateTime object corresponding to the time the entry was last modified.
	 */
	private LocalDateTime lastModified;
}
