package server.entity;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.Id;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * CourseEdition entity representing details of a specific course edition and name of it.
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CourseName {

	/**
	 * The path of the course, also representing the ID for it in the database.
	 */
	@Id
	private String coursePath;

	/**
	 * The name of the course.
	 */
	private String courseName;

	/**
	 * LocalDateTime object corresponding to the time the entry was created.
	 */
	private LocalDateTime timeCreated;

	/**
	 * LocalDateTime object corresponding to the time the entry was last modified.
	 */
	private LocalDateTime lastModified;
}
