package server.entity;

import java.time.LocalDateTime;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import org.springframework.web.bind.annotation.CrossOrigin;

/**
 * Statistics entity containing information about various metrics in a repository.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@CrossOrigin("*")
public class Statistics {

	private String name;

	private String commits;

	private String issues;

	private String mergeRequests;

	private String linesOfCodeAdded;

	private String linesOfCodeRemoved;

	private String comments;

	/**
	 * LocalDateTime object corresponding to the time the entry was created.
	 */
	private LocalDateTime timeCreated;

	/**
	 * LocalDateTime object corresponding to the time the entry was last modified.
	 */
	private LocalDateTime lastModified;

	public Statistics(String name, String commits, String issues, String mergeRequests,
			String linesOfCodeAdded, String linesOfCodeRemoved, String comments) {
		this.name = name;
		this.commits = commits;
		this.issues = issues;
		this.mergeRequests = mergeRequests;
		this.linesOfCodeAdded = linesOfCodeAdded;
		this.linesOfCodeRemoved = linesOfCodeRemoved;
		this.comments = comments;
	}

}
