package server.entity;

import java.time.LocalDateTime;
import java.util.Objects;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import lombok.*;

/**
 * Student group entity representing a student group for a specific course.
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
//@EqualsAndHashCode
public class StudentGroup {

	/**
	 * Unique ID generated automatically for the group.
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private long groupID;

	/**
	 * ID of the course for which the group belongs to.
	 */
	private long courseID;

	/**
	 * Variable representing the path (GitLab path) for the group represented by the entry in the database.
	 */
	private String groupPath;

	/**
	 * Name assigned to a team.
	 */
	private String name;

	public StudentGroup(String name) {
		this.name = name;
	}

	/**
	 * LocalDateTime object corresponding to the time the entry was created.
	 */
	private LocalDateTime timeCreated;

	/**
	 * LocalDateTime object corresponding to the time the entry was last modified.
	 */
	private LocalDateTime lastModified;

	@Override
	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (o == null || this.getClass() != o.getClass())
			return false;
		StudentGroup group = (StudentGroup) o;
		return this.courseID == group.courseID && this.name.equals(group.name);
	}

	@Override
	public int hashCode() {
		return Objects.hash(groupID, courseID, name);
	}
}
