package server.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import org.gitlab4j.api.models.GroupParams;

/**
 * Model for requests involving groups on GitLab.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GroupRequestDTO {
	private String name;
	private String description;

	// recommended only to be used when the dto also contains the course name
	private String editionName;

	private String path;
	private boolean membershipLock;
	// The visibility of a group can be: Private, Internal, or Public.
	// The visibility setting for a group must be at least as restrictive
	// as the visibility of its parent group.
	private String visibility;
	private Long parentId;
	private GroupParams.DefaultBranchProtectionLevel defaultBranchProtectionLevel;
	private String secret;
}
