package server.model;

import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * Model for requests involving a users within groups or projects. Includes the user's ID from GitLab.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MemberRequestDTO {
	private Long userId;
	private Object idOrPath;    // Worth noting that this is used for representation of projects or groups.
	// The role assigned to a user or group is defined in the Gitlab::Access module as access_level.
	//
	//No access (0)
	//Minimal access (5) (Introduced in GitLab 13.5.)
	//Guest (10)
	//Reporter (20)
	//Developer (30)
	//Maintainer (40)
	//Owner (50). Valid for projects in GitLab 14.9 and later.
	private Integer accessLevel;
	@JsonFormat(locale = "nl", shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "Europe/Amsterdam")
	private Date expiresAt;

	private String secret;
}
