package server.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Model for requests involving projects.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ProjectRequestDTO {
	private Object projectIdOrPath;
	private String name;
	private String description;
	private Long namespaceId;
	private boolean issuesEnabled;
	private boolean mergeRequestsEnabled;
	private boolean wikiEnabled;
	private boolean snippetsEnabled;
	private boolean isPublic;
}
