package server.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import org.gitlab4j.api.models.GroupParams;

/**
 * Model used for the request to set up a course edition. Contains information about the course edition, as
 * well as settings for the repositories and the students to add to groups.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SetUpRequestDTO {
	private String fileContent;
	private String coursePath;
	private String courseName;
	private String courseEdition;
	private String forkPath;
	private String groupVisibility;
	private Boolean repoVisibility;
	private GroupParams.DefaultBranchProtectionLevel defaultBranchProtectionLevel;
	private int spIndex;
	private Boolean enableIndividualRepositories;
	private String individualRepoForkPath;
	private String secret;
	private Integer weeksOfStatistics;
}
