package server.model;

import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * Model for requests involving a users within groups or projects. Includes username.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UserRequestDTO {
	private String email;
	private String username;
	private Integer accessLevel;
	private String courseName;
	private String courseEdition;
	private String groupPath;
	@JsonFormat(locale = "nl", shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "Europe/Amsterdam")
	private Date expiresAt;
	private String secret;
}
