package server.properties;

import lombok.Data;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties("gitbull.frontend")
public class FrontendProperties {

	/**
	 * Base URL where the frontend server is hosted. When running from 'npm run dev' with default settings,
	 * the URL would be: localhost:5173.
	 */
	private String url;

	/**
	 * The key of the API key used to authenticate to the GitBull frontend server.
	 */
	private String apiKey;

	/**
	 * The secret of the API key used to authenticate to the GitBull frontend server.
	 */
	private String apiSecret;
}
