package server.properties;

import lombok.Data;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties("gitbull.statistics")
public class StatisticsProperties {

	/**
	 * URL of Gitlab instance.
	 */
	private String gitlabUrl;

	/**
	 * How detailed logs of scripts should be; OUTPUT: print output of terminal; LOG: logs success/failure of
	 * command; FULL: both; NONE: none (default);
	 */
	private String loggingLevel;

	/**
	 * Username of account that will clone the repositories
	 */
	private String username;

	/**
	 * API key of account that will clone the repositories. Appears to require sudo. Yikes!
	 */
	private String apiKey;

	/**
	 * Whether to enable the scheduler.
	 */
	private boolean enableScheduler;

	/**
	 * Whether to enable the statistics installation.
	 */
	private boolean installStatistics;

	/**
	 * A string defining the schedule for the statistics. Cron4j uses a string pattern to define the schedule.
	 * More information <a href="http://www.sauronsoftware.it/projects/cron4j/manual.php">here.</a>
	 */
	private String schedule;
}
