package server.security.memory;

import static nl.tudelft.labracore.lib.security.user.DefaultRole.ADMIN;
import static nl.tudelft.labracore.lib.security.user.DefaultRole.STUDENT;
import static nl.tudelft.labracore.lib.security.user.DefaultRole.TEACHER;

import nl.tudelft.labracore.api.PersonControllerApi;
import nl.tudelft.labracore.lib.security.memory.InMemoryUserProvider;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile("!production")
public class DevUserDetailsProvider extends InMemoryUserProvider {

	@Autowired
	private PersonControllerApi pApi;

	/**
	 * Provides users to log into for development testing purposes.
	 */
	public DevUserDetailsProvider() {
		super();
		add("CSE Student 1", 11, STUDENT, "pass");
		add("Admin 1", 1, ADMIN, "pass");
		add("CSE Teacher 1", 5, TEACHER, "pass");
	}
}
