package server.service;

import java.util.HashMap;

import nl.tudelft.labracore.lib.security.user.Person;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * The SecretMatcher class is responsible for managing a mapping between secrets and persons. It provides
 * methods to add a secret-person pair and retrieve a person based on a secret.
 */
@Service
public class SecretMatcher {
	/**
	 * HashMap storing the mapping between secrets and persons.
	 */
	private final HashMap<String, Person> match;

	/**
	 * Constructs a new SecretMatcher with an empty mapping.
	 */
	@Autowired
	public SecretMatcher() {
		this.match = new HashMap<>();
	}

	/**
	 * Adds a secret-person pair to the mapping.
	 *
	 * @param secret The secret to be added.
	 * @param person The person associated with the secret.
	 */
	public void add(String secret, Person person) {
		match.put(secret, person);
	}

	/**
	 * Retrieves the person associated with the provided secret.
	 *
	 * @param  secret The secret for which to retrieve the associated person.
	 * @return        The person associated with the secret, or {@code null} if the secret is not found.
	 */
	public Person get(String secret) {
		return match.get(secret);
	}
}
