package server.service.util;

/**
 * Class used to decode the accessLevel from GitLab to roles stored in Accesses from Database
 */
public class RoleDecoder {
	/**
	 * Method that decodes the accessLevel from GitLab to a role from Access entries.
	 *
	 * @param  accessLevel accessLevel from GitLab, being an int from 0 to 50 representing the permissions
	 *                     over a specific repository.
	 * @return             an int representing the coded permission to be stored in an access entry.
	 */
	public static int roleDecoder(int accessLevel) {
		int role = 0;
		if (accessLevel <= 30)
			role = 1;
		else if (accessLevel <= 40)
			role = 2;
		else if (accessLevel <= 50)
			role = 3;

		return role;
	}
}
