package server.service.util;

import java.util.concurrent.CompletableFuture;

import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.User;
import org.springframework.scheduling.annotation.Async;

import server.entity.Account;

public class ThreadedUtils {

	/**
	 * Default constructor
	 */
	public ThreadedUtils() {

	}

	/**
	 * Gets a user from the GitLab instance by their email asynchronously. Requires further performance
	 * testing.
	 *
	 * @param  gitLabApi          GitLabApi object used to interact with a GitLab instance
	 * @param  account            Account object containing the user's email
	 * @return                    User object representing the user from the GitLab instance
	 * @throws GitLabApiException If any exception occurs
	 */
	@Async
	public CompletableFuture<User> asyncGetUserByEmail(GitLabApi gitLabApi, Account account)
			throws GitLabApiException {
		return CompletableFuture
				.completedFuture(gitLabApi.getUserApi().getUserByEmail(account.getEmail().toLowerCase()));
	}

}
