package server.statistics;

import java.io.IOException;
import java.util.ArrayList;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import server.statistics.util.PythonFolderChecker;
import server.util.FancyPrint;

/**
 * Service that allows the installation of statistics dependencies.
 */
@Service
public class StatisticsInstall {

	@Autowired
	CommandRunner commandRunner;

	@Value("${gitbull.statistics.install-statistics}")
	private boolean enableStatisticsInstallation;

	@Autowired
	PythonFolderChecker pythonFolderChecker;

	/**
	 * Installs Python scripts and dependencies for statistics analysis. This method is called during bean
	 * initialization.
	 *
	 * @return                      A list of commands executed during the installation process.
	 * @throws IOException          If an I/O error occurs.
	 * @throws InterruptedException If the current thread is interrupted while waiting for the installation
	 *                              process to complete.
	 */
	@PostConstruct
	public ArrayList<String> installPythonScripts() throws IOException, InterruptedException {

		ArrayList<String> commands = new ArrayList<>();

		if (!pythonFolderChecker.pythonFolderIsEmpty() || !enableStatisticsInstallation) {
			FancyPrint.println("statistics", "Analysis scripts already present at /statistics/python/");
			FancyPrint.println("statistics",
					"If you wish to re-install scripts, delete the contents of /statistics/python/");
			return null;
		} else {
			//Set up directories
			commands.add("mkdir python");
			commands.add("mkdir repo");

			//Install Geit
			commands.add("MOVETO /python");
			commands.add("git clone https://github.com/kelhaji/geit");
			commands.add("MOVETO /python/geit");
			commands.add("pip3 install -r requirements.txt");

			//Install gitinspector
			commands.add("MOVETO /python");
			commands.add("git clone https://github.com/ejwa/gitinspector");
		}

		commandRunner.runScript(commands);
		return commands;
	}
}
