package server.statistics.util;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

import lombok.Generated;

import org.springframework.stereotype.Component;

/**
 * This class checks python folders.
 */
@Component
public class PythonFolderChecker {
	/**
	 * Checks if the designated python folder is empty. This method is not, in fact, auto-generated. However,
	 * it is objectively untestable: There is no consistently expected behaviour, you either have it or you
	 * don't and both are valid cases.
	 *
	 * Jacoco ignores anything that is annotated with anything containing "Generated" So, there you go.
	 *
	 * @return whether it is empty.
	 */
	@Generated
	public boolean pythonFolderIsEmpty() {
		Path path = Path.of("statistics", "python");
		try (Stream<Path> entries = Files.list(path)) {
			return entries.findFirst().isEmpty();
		} catch (Exception e) {
			return true;
		}
	}
}
