package server.statistics.util;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;

/**
 * A list of repositories and weeks left to run statistics for. courseName: path to course weeks: how many
 * more weeks should the statistics for this repo be run? automatically decreases by 1 everytime statistics
 * are run. when it reaches 0, that entry is removed from the list.
 */
@Getter
@ToString
@EqualsAndHashCode
public class StatisticsEntry {
	private final String courseName;
	private final Integer weeks;
	private Integer atWeek;

	public StatisticsEntry(String courseName, Integer weeks) {
		this.courseName = courseName;
		this.weeks = weeks;
		atWeek = 1;
	}

	/**
	 * Counts a week, indicating this repo has been analyzed one more time.
	 *
	 * @return if the entry needs to be deleted, indicating that this repo's analysis period has ended.
	 */
	public boolean countWeek() {
		return ++atWeek > weeks;
	}
}
