package server.statistics.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;

/**
 * The StreamConsumer class is responsible for consuming the output of an InputStream by passing it to a
 * provided Consumer String function.
 */
public class StreamConsumer implements Runnable {

	private final InputStream inputStream;
	private final Consumer<String> consumer;

	/**
	 * Constructs a new StreamConsumer with the specified InputStream and Consumer function.
	 *
	 * @param inputStream The InputStream to consume.
	 * @param consumer    The Consumer function to process the input stream lines.
	 */
	public StreamConsumer(InputStream inputStream, Consumer<String> consumer) {
		this.inputStream = inputStream;
		this.consumer = consumer;
	}

	/**
	 * Reads the lines from the InputStream and passes them to the Consumer function. This method is executed
	 * when the StreamConsumer is run as a separate thread.
	 */
	@Override
	public void run() {
		new BufferedReader(new InputStreamReader(inputStream)).lines()
				.forEach(consumer);
	}
}
