package server.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Utility class for clearer console prints.
 */
public class FancyPrint {

	public static void println(String category, String message) {
		System.out.println(new StringBuilder()
				.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS")))
				.append("\t").append("[").append(category.toUpperCase()).append("] ").append(message));
	}
}
