package server.csvconverter;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StudentEmailValidatorTest {

	private StudentEmailValidator validator;

	@BeforeEach
	void setUp() throws Exception {
		validator = new StudentEmailValidator();
	}

	@Test
	public void testValidateValidMail() {
		assertTrue(validator.validate("euleia@student.tudelft.nl"));
		assertTrue(validator.validate("eauleia@student.tudelft.nl"));
	}

	@Test
	public void testValidateInvalidMail() {
		assertFalse(validator.validate("euleia@studen.tudelft.nl"));
		assertFalse(validator.validate("eul@eia@student.tudelft.nl"));
		assertFalse(validator.validate("euleia@stunt.tudelft.nl"));
		assertFalse(validator.validate("euleia@gmail.com"));
		assertFalse(validator.validate("eule@ia@gmail.com"));

	}

}
