package server.csvconverter;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UTF8ValidatorTest {

	private UTF8Validator validator;
	private String filePath;
	private String testContent;

	@BeforeEach
	void setUp() throws Exception {
		filePath = "utf8test.txt";
		FileOutputStream fileStream = new FileOutputStream(filePath);
		OutputStreamWriter streamWriter = new OutputStreamWriter(fileStream, "UTF-8");
		BufferedWriter writer = new BufferedWriter(streamWriter);
		testContent = "Test Content with non-UTF-8 characters: \u00E9\u00F1\u00F6\n";
		writer.write(testContent);
		writer.close();

		validator = new UTF8Validator(filePath);
	}

	@AfterEach
	void tearDown() throws Exception {
		File file = new File(filePath);
		file.delete();
	}

	@Test
	void testIsValidUtf8() throws Exception {
		assertTrue(UTF8Validator.isValidUtf8(testContent));
		assertFalse(!UTF8Validator.isValidUtf8("Test \uD83D\uDCA9"));
	}

	@Test
	void testReplaceNonUtf8Characters() throws Exception {
		String replacedContent = UTF8Validator.replaceNonUtf8Characters(testContent);
		assertTrue(UTF8Validator.isValidUtf8(replacedContent));
		assertFalse(!replacedContent.contains("\u00E9"));
	}

	@Test
	void testValidate() throws Exception {
		validator.validate();
		byte[] fileContentBytes = Files.readAllBytes(Paths.get(filePath));
		String fileContent = new String(fileContentBytes, StandardCharsets.UTF_8);
		assertTrue(UTF8Validator.isValidUtf8(fileContent));
		assertFalse(!fileContent.contains("\u00E9"));
	}
}
