package server.security;

import static org.junit.jupiter.api.Assertions.*;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import org.junit.jupiter.api.Test;

class HmacValidatorTest {
	@Test
	void computeHash_NullSecret_ThrowsInvalidKeyException() {
		String secret = null;
		byte[] payload = "Hello, world!".getBytes();

		assertThrows(NullPointerException.class, () -> HmacValidator.ComputeHash(secret, payload));
	}

	@Test
	void hashIsValid_ValidHash_ReturnsTrue() throws InvalidKeyException, NoSuchAlgorithmException {
		String secret = "secret";
		byte[] payload = "Hello, world!".getBytes();
		String hash = HmacValidator.ComputeHash(secret, payload);

		boolean isValid = HmacValidator.HashIsValid(secret, payload, hash);

		assertTrue(isValid);
	}

	@Test
	void hashIsValid_InvalidHash_ReturnsFalse() throws InvalidKeyException, NoSuchAlgorithmException {
		String secret = "secret";
		byte[] payload = "Hello, world!".getBytes();
		String hash = "InvalidHash";

		boolean isValid = HmacValidator.HashIsValid(secret, payload, hash);

		assertFalse(isValid);
	}

	@Test
	void hashIsValid_NullSecret_ThrowsInvalidKeyException() {
		String secret = null;
		byte[] payload = "Hello, world!".getBytes();
		String hash = "SomeHash";

		assertThrows(NullPointerException.class, () -> HmacValidator.HashIsValid(secret, payload, hash));
	}

	@Test
	void hashIsValid_NullPayload_ThrowsNullPointerException() {
		String secret = "secret";
		byte[] payload = null;
		String hash = "SomeHash";

		try {
			HmacValidator.HashIsValid(secret, payload, hash);
		} catch (Exception e) {
			fail();
		}
	}
}
