package server.service;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import org.junit.jupiter.api.Test;

import server.entity.CourseName;
import server.repository.CourseNamesRepository;

class CourseNameServiceTest {

	@Test
	void saveCourseName() {
		CourseNamesRepository repo = mock(CourseNamesRepository.class);
		CourseNameService service = new CourseNameService();
		service.setRepository(repo);

		CourseName courseName = CourseName.builder().coursePath("CS101")
				.courseName("Introduction to Computer Science").build();
		when(repo.save(courseName)).thenReturn(courseName);

		CourseName savedCourseName = service.saveCourseName(courseName);

		verify(repo).save(courseName);

		assertEquals(courseName, savedCourseName);
	}

	@Test
	void deleteCourseNames() {
		CourseNamesRepository repo = mock(CourseNamesRepository.class);
		CourseNameService service = new CourseNameService();
		service.setRepository(repo);

		String coursePath = "CS101";
		doNothing().when(repo).deleteById(coursePath);
		service.deleteCourseNames(coursePath);
		verify(repo, times(1)).deleteById(coursePath);
	}

	@Test
	void fetchAllCoursesNames() {
		CourseNamesRepository repo = mock(CourseNamesRepository.class);
		CourseNameService service = new CourseNameService();
		service.setRepository(repo);

		List<CourseName> courseNames = new ArrayList<>();
		CourseName courseName1 = CourseName.builder().coursePath("CS101")
				.courseName("Introduction to Computer Science").build();
		CourseName courseName2 = CourseName.builder().coursePath("CS102")
				.courseName("Introduction to Computer Science").build();
		courseNames.add(courseName1);
		courseNames.add(courseName2);

		when(repo.findAll()).thenReturn(courseNames);
		List<CourseName> fetchedCourseNames = service.fetchAllCoursesNames();

		assertEquals(courseNames, fetchedCourseNames);
	}

	@Test
	void fetchNameForCoursePath() {
		CourseNamesRepository repo = mock(CourseNamesRepository.class);
		CourseNameService service = new CourseNameService();
		service.setRepository(repo);

		String coursePath = "CS101";
		CourseName courseName = CourseName.builder().coursePath(coursePath)
				.courseName("Introduction to Computer Science").build();

		when(repo.findById(coursePath)).thenReturn(Optional.of(courseName));
		String fetchedCourseName = service.fetchNameForCoursePath(coursePath);

		assertEquals(courseName.getCourseName(), fetchedCourseName);
	}

	@Test
	void fetchNameForCoursePath_NotFound() {
		CourseNamesRepository repo = mock(CourseNamesRepository.class);
		CourseNameService service = new CourseNameService();
		service.setRepository(repo);

		String coursePath = "CS101";

		when(repo.findById(coursePath)).thenReturn(Optional.empty());
		String fetchedCourseName = service.fetchNameForCoursePath(coursePath);

		assertNull(fetchedCourseName);
	}

	@Test
	void saveCourseName_AlreadyExisting() {
		CourseNamesRepository repo = mock(CourseNamesRepository.class);
		CourseNameService service = new CourseNameService();
		service.setRepository(repo);

		CourseName courseName = CourseName.builder().coursePath("CS101")
				.courseName("Introduction to Computer Science").build();
		when(repo.save(courseName)).thenReturn(courseName);
		when(repo.findById(any())).thenReturn(Optional.of(courseName));
		CourseName savedCourseName = service.saveCourseName(courseName);

		verify(repo).save(courseName);

		assertEquals(courseName, savedCourseName);
	}
}
