package server.service;

import static org.junit.jupiter.api.Assertions.*;

import org.gitlab4j.api.GitLabApi;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

class InstanceMappingServiceTest {
	@InjectMocks
	private InstanceMappingService instanceMappingService;
	@Mock
	private GitLabApi rootGitLabApi;

	@BeforeEach
	void setUp() {
		MockitoAnnotations.openMocks(this);
		instanceMappingService.serverUrl = "default-value";
		rootGitLabApi = new GitLabApi("test.com", "token");
		instanceMappingService.addInstance("john.doe", "api_key_1");
		instanceMappingService.addInstance("jane.smith", "api_key_2");
	}

	@Test
	void testAddInstance() {
		String username = "alice";
		String apiKey = "api_key_3";
		instanceMappingService.addInstance(username, apiKey);

		GitLabApi gitLabApi = instanceMappingService.getInstance(username);
		assertNotNull(gitLabApi);
		assertEquals(apiKey, gitLabApi.getAuthToken());
	}

	@Test
	void testRemoveInstance() {
		String username = "john.doe";
		instanceMappingService.removeInstance(username);

		GitLabApi gitLabApi = instanceMappingService.getInstance(username);
		assertNull(gitLabApi);

		String nonExistingUsername = "non_existing_user";
		instanceMappingService.removeInstance(nonExistingUsername);

		assertNull(instanceMappingService.getInstance(nonExistingUsername));
	}

	@Test
	void testGetInstanceByUsername() {
		String username = "jane.smith";
		GitLabApi gitLabApi = instanceMappingService.getInstance(username);
		assertNotNull(gitLabApi);
		assertEquals("api_key_2", gitLabApi.getAuthToken());

		String nonExistingUsername = "non_existing_user";
		GitLabApi nonExistingApi = instanceMappingService.getInstance(nonExistingUsername);
		assertNull(nonExistingApi);
	}
}
