package server.service.util;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.Test;

class RoleDecoderTest {

	@Test
	public void testRoleDecoderLowerBound() {
		int accessLevel = 0;
		int expectedRole = 1;
		int decodedRole = RoleDecoder.roleDecoder(accessLevel);
		assertEquals(expectedRole, decodedRole);
	}

	@Test
	public void testRoleDecoderWithinRange() {
		int accessLevel = 35;
		int expectedRole = 2;
		int decodedRole = RoleDecoder.roleDecoder(accessLevel);
		assertEquals(expectedRole, decodedRole);
	}

	@Test
	public void testRoleDecoderUpperBound() {
		int accessLevel = 50;
		int expectedRole = 3;
		int decodedRole = RoleDecoder.roleDecoder(accessLevel);
		assertEquals(expectedRole, decodedRole);
	}

	@Test
	public void testRoleDecoderAboveRange() {
		int accessLevel = 60;
		int expectedRole = 0;
		int decodedRole = RoleDecoder.roleDecoder(accessLevel);
		assertEquals(expectedRole, decodedRole);
	}
}
