package server.statistics;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

import java.io.IOException;

import org.junit.jupiter.api.Test;

public class CommandRunnerTest {

	@Test
	void checkWSL_ShouldPrintErrorMessageWhenCannotRunProgram() {
		IOException ioException = new IOException("Cannot run program");

		try {
			CommandRunner.checkWSL(ioException);
		} catch (IOException e) {
			fail();
		}
	}

	@Test
	void checkWSL_ShouldThrowExceptionWhenMessageDoesNotStartWithCannotRunProgram() {
		IOException ioException = new IOException("Some other error");

		assertThrows(IOException.class, () -> CommandRunner.checkWSL(ioException));
	}
}
