package server.statistics;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

import java.util.ArrayList;

import lombok.SneakyThrows;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;

import server.statistics.util.PythonFolderChecker;

public class StatisticsInstallTest {

	@InjectMocks
	private StatisticsInstall statisticsInstall;

	@Mock
	private CommandRunner cr;

	@Mock
	private PythonFolderChecker pythonFolderChecker;

	@BeforeEach
	void setUp() {
		MockitoAnnotations.openMocks(this);

		ReflectionTestUtils.setField(statisticsInstall, "enableStatisticsInstallation", true);
		when(pythonFolderChecker.pythonFolderIsEmpty()).thenReturn(true);
	}

	@SneakyThrows
	@Test
	public void testProperCommands() {
		doNothing().when(cr).runScript(any());

		ArrayList<String> properCommands = new ArrayList<>();
		properCommands.add("mkdir python");
		properCommands.add("mkdir repo");
		properCommands.add("MOVETO /python");
		properCommands.add("git clone https://github.com/kelhaji/geit");
		properCommands.add("MOVETO /python/geit");
		properCommands.add("pip3 install -r requirements.txt");
		properCommands.add("MOVETO /python");
		properCommands.add("git clone https://github.com/ejwa/gitinspector");

		assertEquals(properCommands, statisticsInstall.installPythonScripts());
	}

	@SneakyThrows
	@Test
	public void testNoDoubleInstall() {
		when(pythonFolderChecker.pythonFolderIsEmpty()).thenReturn(false);

		assertNull(statisticsInstall.installPythonScripts());
	}

	@SneakyThrows
	@Test
	public void testNoInstallWhenDisabled() {
		ReflectionTestUtils.setField(statisticsInstall, "enableStatisticsInstallation", false);

		assertNull(statisticsInstall.installPythonScripts());
	}
}
