package server.statistics;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;

import it.sauronsoftware.cron4j.Scheduler;

public class StatisticsSchedulerTest {
	@InjectMocks
	private StatisticsScheduler statisticsScheduler;

	@Mock
	private Scheduler scheduler;

	@Mock
	private StatisticsRunner statisticsRunner;

	@BeforeEach
	void setUp() {
		MockitoAnnotations.openMocks(this);

		ReflectionTestUtils.setField(statisticsScheduler, "enabled", true);
		ReflectionTestUtils.setField(statisticsScheduler, "scheduler", scheduler);
	}

	@Test
	public void testDisabled() {
		ReflectionTestUtils.setField(statisticsScheduler, "enabled", false);

		statisticsScheduler.init();

		verify(scheduler, never()).start();
	}

	@Test
	public void testEnabled() {
		statisticsScheduler.init();

		verify(scheduler, atLeastOnce()).schedule(any(), eq(statisticsRunner));
		verify(scheduler, atLeastOnce()).start();
	}
}
