

describe('About Page', () => {
  beforeEach(() => {
    cy.visit('http://localhost:5173/about'); 
  });

  it('displays the correct title', () => {
    cy.get('h1')
      .should('have.class', 'text-5xl')
      .and('have.class', 'font-bold')
      .and('have.class', 'text-white')
      .and('have.class', 'text-center')
      .and('have.class', 'my-16')
      .and('contain.text', 'About GitBull');
  });

  it('displays the "Before GitBull" card with the correct content', () => {
    cy.get('h1[slot="card-title"]').eq(0).should('have.text', 'Before GitBull');
  });

  it('displays the "What is GitBull?" card with the correct content', () => {
    cy.get('h1[slot="card-title"]').eq(1).should('have.text', 'What is GitBull?');
  });

  it('displays the "Development team" card with the correct content', () => {
    cy.get('h1[slot="card-title"]').eq(2).should('have.text', 'Development team');
    cy.get('div[slot="card-content"]').eq(2).find('li').should('have.length', 5);
    cy.get('div[slot="card-content"]').eq(2).find('li').eq(0).should('have.text', 'Ana Cristiana Marcu');
    cy.get('div[slot="card-content"]').eq(2).find('li').eq(1).should('have.text', 'Radu Stefan Ezaru');
    cy.get('div[slot="card-content"]').eq(2).find('li').eq(2).should('have.text', 'Elena Uleia');
    cy.get('div[slot="card-content"]').eq(2).find('li').eq(3).should('have.text', 'Albert Alexandru Sandu');
    cy.get('div[slot="card-content"]').eq(2).find('li').eq(4).should('have.text', 'Serban Alexandru Ungureanu');
  });
});
