
describe('Account Page', () => {
  beforeEach(() => {
    cy.visit('http://localhost:5173/account'); 
    cy.visit('http://localhost:8080/custom-login'); 
    cy.get('#input-username').type('admin1');
    cy.get('#input-password').type('pass');
    cy.get('input.btn.btn-primary').click();
    cy.visit('http://localhost:5173/account'); 
  });


  it('displays the account overview and manages API key', () => {
    cy.get('NotLoggedInPage').should('not.exist');

    cy.get('h1').should('contain', 'Account');

    cy.get('div[slot="card-title"]').should('contain', 'Manage API Key');
    cy.get('div[slot="card-content"]').within(() => {
      cy.get('.text-gray-900').should('exist');

      cy.get('input[type="password"]').type('glpat-RRkywDrAoRu1mj3X8Xt7');

      cy.get('button')
        .contains('Delete current key')
        .click();
      cy.get('.text-red-500')
        .contains('Cancel')
        .click();

      cy.get('button')
        .contains('Upload entered key')
        .click();
    });
  });


 })