describe('Access Create Course Page', () => {
  beforeEach(() => {
    cy.visit('http://localhost:5173/account'); 
    cy.visit('http://localhost:8080/custom-login'); 
    cy.get('#input-username').type('admin1');
    cy.get('#input-password').type('pass');
    cy.get('input.btn.btn-primary').click();
    cy.visit('http://localhost:5173/account'); 
  });

  it('should display the page content when logged in as a non-student and access my courses page', () => {
    cy.get('NotLoggedInPage').should('not.exist');

    cy.get('h1').should('contain', 'Account');

    cy.get('div[slot="card-title"]').should('contain', 'Manage API Key');
    cy.get('div[slot="card-content"]').within(() => {
      cy.get('.text-gray-900').should('exist');

      cy.get('input[type="password"]').type('glpat-RRkywDrAoRu1mj3X8Xt7');

      cy.get('button')
        .contains('Delete current key')
        .click();
      cy.get('.text-red-500')
        .contains('Cancel')
        .click();

      cy.get('button')
        .contains('Upload entered key')
        .click();
    });

    cy.visit('http://localhost:5173/mycourses'); 
    cy.intercept('POST', '/api/frontend/isLoggedIn', { body: true })
    cy.intercept('POST', '/api/frontend/getRole', { body: 'TEACHER' })
  
    cy.get('NotLoggedInPage').should('not.exist')
  
    cy.contains('h1', 'GitBull')
    cy.contains('h1', 'Your Courses')

    cy.get('#newCourseCard').should('exist')

    cy.contains('h1', 'New course')
    cy.contains('p', 'Here you can add a new course or course edition.')


    cy.contains('a', 'New Configuration')
      .should('have.attr', 'href', '/create_courses').click()
        cy.url().should('include', '/create_courses') 

    // Verify that the dropdown content is initially hidden
    cy.get('div[slot="dropdown-title"]').eq(0).contains('Create Course');
    cy.get('div[slot="dropdown-title"]').eq(1).contains('Add Teacher');
    cy.get('div[slot="dropdown-title"]').eq(2).contains('Create Edition');

    // Click the dropdown button
    cy.get('button[id="dropdownCourseButton"]').eq(0).should('be.visible').wait(1000).click();


    // Select an option from the dropdown menu
    cy.get('button[id="addButton"]').should('be.visible').wait(1000).click();
    cy.get('input[type="newName"]').should('be.visible').type('Course Name');
    cy.get('input[type="description"]').should('be.visible').type('Course Description');
    cy.get('button').contains('Create').click();
    cy.get('.font-bold').should('contain', 'The course');

    // Test adding a teacher
    cy.get('button[id="dropdownCourseButton"]').eq(1).should('be.visible').wait(1000).click();
    cy.get('input[type="teacherNetId"]').type('12345');
    cy.get('input[type="coursePath"]').type('coursename');
    cy.get('button[id="addTeacher"]').click();
    cy.get('.font-bold').should('contain', 'The teacher could not be added.');


    // Test creating an edition
    cy.get('button[id="dropdownCourseButton"]').eq(2).should('be.visible').click();
    cy.get('button[id="createEdition"]').click();
    cy.get('.font-bold').should('contain', 'The edition');    


    // Select an option from the dropdown menu
    cy.get('input[type="newName"]').wait(1000).type(' New');
    cy.get('button').contains('Create').click();
    cy.get('.font-bold').should('contain', 'The course');

    // Test adding a teacher
    cy.get('input[type="coursePath"]').type('new');
    cy.get('button[id="addTeacher"]').click();
    cy.get('.font-bold').should('contain', 'The teacher could not be added.');

    // Test creating an edition
    cy.get('button[id="createEdition"]').click();
    cy.get('.font-bold').should('contain', 'The edition');

    cy.visit('http://localhost:5173/mycourses'); 

    cy.get('div[id="cardCourse"]').should('exist');

    cy.get('div[id="cardCourse"]').eq(0).should('exist');
    cy.get('div[id="cardCourse"]').eq(1).should('exist');

    cy.get('h1[slot="card-title"]').eq(2).contains("Course Name");
    cy.get('h1[slot="card-title"]').eq(3).contains("Course Name New");

    cy.get('h1[slot="card-title"]').eq(2).contains("2022-2023");
    cy.get('h1[slot="card-title"]').eq(3).contains("2022-2023");

    cy.get('span[id="role"]').eq(0).contains("TEACHER");
    cy.get('span[id="role"]').eq(1).contains("TEACHER");

    cy.get('button[id="stats2"]').eq(0).click();
    cy.visit('http://localhost:5173/mycourses'); 

    cy.get('button[id="setup"]').eq(0).click();
    cy.visit('http://localhost:5173/mycourses'); 

    cy.get('button[id="edit"]').eq(0).click();
    cy.visit('http://localhost:5173/mycourses'); 
    })   
})
