import 'cypress-file-upload';
describe('Access Create Course Page', () => {
  beforeEach(() => {
    cy.visit('http://localhost:5173/account'); 
    cy.visit('http://localhost:8080/custom-login'); 
    cy.get('#input-username').type('admin1');
    cy.get('#input-password').type('pass');
    cy.get('input.btn.btn-primary').click();
    cy.visit('http://localhost:5173/account'); 
  });

  it('should display the page content when logged in as a non-student and access my courses page', () => {
    cy.get('NotLoggedInPage').should('not.exist');

    cy.get('h1').should('contain', 'Account');

    cy.get('div[slot="card-title"]').should('contain', 'Manage API Key');
    cy.get('div[slot="card-content"]').within(() => {
      cy.get('.text-gray-900').should('exist');

      cy.get('input[type="password"]').type('glpat-RRkywDrAoRu1mj3X8Xt7');

      cy.get('button')
        .contains('Delete current key')
        .click();
      cy.get('.text-red-500')
        .contains('Cancel')
        .click();

      cy.get('button')
        .contains('Upload entered key')
        .click();
    });

    cy.visit('http://localhost:5173/mycourses'); 
    cy.intercept('POST', '/api/frontend/isLoggedIn', { body: true })
    cy.intercept('POST', '/api/frontend/getRole', { body: 'TEACHER' })
    cy.intercept('POST', '/api/frontend/getRole', { body: 'TEACHER' })
  
    cy.get('NotLoggedInPage').should('not.exist')
  
    cy.contains('h1', 'GitBull')
    cy.contains('h1', 'Your Courses')

    cy.get('#newCourseCard').should('exist')

    cy.contains('h1', 'New course')
    cy.contains('p', 'Here you can add a new course or course edition.')


    cy.contains('a', 'New Configuration')
      .should('have.attr', 'href', '/create_courses').click()
        cy.url().should('include', '/create_courses') 

    // Verify that the dropdown content is initially hidden
    cy.get('div[slot="dropdown-title"]').eq(0).contains('Create Course');
    cy.get('div[slot="dropdown-title"]').eq(1).contains('Add Teacher');
    cy.get('div[slot="dropdown-title"]').eq(2).contains('Create Edition');

    // Click the dropdown button
    cy.get('button[id="dropdownCourseButton"]').eq(0).should('be.visible').wait(1000).click();


    // Select an option from the dropdown menu
    cy.get('button[id="addButton"]').should('be.visible').wait(1000).click();
    cy.get('input[type="newName"]').should('be.visible').type('Course Name Test');
    cy.get('input[type="description"]').should('be.visible').type('Course Description');
    cy.get('button').contains('Create').click();
    cy.get('.font-bold').should('contain', 'The course');

    // Test adding a teacher
    cy.get('button[id="dropdownCourseButton"]').eq(1).should('be.visible').wait(1000).click();
    cy.get('input[type="teacherNetId"]').type('12345');
    cy.get('input[type="coursePath"]').type('coursenametest');
    cy.get('button[id="addTeacher"]').click();
    cy.get('.font-bold').should('contain', 'The teacher could not be added.');


    // Test creating an edition
    cy.get('button[id="dropdownCourseButton"]').eq(2).should('be.visible').click();
    cy.get('button[id="createEdition"]').click();


    //Test go back to home page
    cy.visit('http://localhost:5173/mycourses'); 

    //Access setup for Course Name Test
    cy.get('a[href="/course/new"]')  
    .find('button#setup')          
    .click(); 

    // Click the dropdown button Add CSV
    cy.get('button[id="dropdownCourseButton"]').eq(0).should('be.visible').wait(1000).click();
    cy.get('label#labelChooseFile').click()

    // Upload file example.csv
    cy.get('input[type=file]').selectFile('cypress/fixtures/example.csv', {
       action: 'drag-drop',
       force: true 
    })
    console.log(cy.fixture("example.csv"))
    
    // Click the dropdown button Setup
    cy.get('button[id="dropdownCourseButton"]').eq(1).should('be.visible').wait(1000).click();

    //Test for already filled fields
    cy.get('input[placeholder="Enter here..."]').eq(0).should('have.value', 'Course Name Test');
    cy.get('input[placeholder="Enter here..."]').eq(1).should('have.value', '2022-2023');

    //Fill in rest
    cy.get('input[placeholder="Enter here..."]').eq(2).type('coursenametest/2022-2023')
    cy.get('input[placeholder="Enter here..."]').eq(1).should('have.value', '2022-2023');
    cy.get('#selectBranch').get('select').eq(0).select('not protected');
    
    
    cy.get('div.flex.justify-end button').click();

    //Test receipt information
    cy.get('button[id="dropdownCourseButton"]').eq(2).should('be.visible').wait(1000).click();
    cy.get('.bg-white.bg-opacity-50').eq(2)
      .should('be.visible') 
      .within(() => {
        cy.contains('You are about to set up the course: Course Name Test.').should('be.visible');
        cy.contains('That has the edition: 2022-2023.').should('be.visible');
        cy.contains('The protection of the main branch will be set to: not protected.').should('be.visible');
        cy.contains('The visibility of the project will be set to: private.').should('be.visible');
        cy.contains('The visibility of the project will be set to: private.').should('be.visible');
        cy.contains('The visibility of the project will be set to: true.').should('be.visible');
        cy.contains('Enable individual repositories: true.').should('be.visible');
        cy.contains('The individual repositories will be empty. The first commit is a ReadME file.').should('be.visible');
      });
    
    
    cy.get("#divSubmitSetup").find("button").click()

    cy.get('a.text-sm.font-bold.text-white')
      .find('button')
    .click();

    //Test error log 
    cy.get('div[slot="dropdown-title"]').eq(3).contains('Get error log');
    cy.get('button[id="dropdownCourseButton"]').eq(3).should('be.visible').wait(1000).click();
    cy.get('div[slot="dropdown-content"]').eq(3).contains('Setup is complete');

    //Test add TA appears
    cy.get('div[slot="dropdown-title"]').eq(4).contains('Add TAs');
    cy.get('button[id="dropdownCourseButton"]').eq(4).should('be.visible').wait(1000).click();
    cy.get('div[slot="dropdown-content"]').eq(4).get("div.flex.justify-center.gap-4").get('button.bg-white').contains('Assign to all groups');
    cy.get('div[slot="dropdown-content"]').eq(4).get("div.flex.justify-center.gap-4").get('button.bg-white').contains('Assign individually');
    
 
    });

  })

        