import axios from 'axios';

export let _coursePath:string = ""
export let _groupPath:string = ""
export let _role:string = ""
export let _courseName:string = ""
export let _courseEdition:string = ""

export function _setCourseEdition(courseEdition: any) {
    _courseEdition = courseEdition
}

export function _setCourseName(courseName: any) {
    _courseName = courseName
}

export function _setCoursePath(coursePath: any) {
    _coursePath = coursePath
}

export function _setGroupPath(groupPath: any) {
    _groupPath = groupPath
}

export function _setRole(role: any) {
    _role = role
}

export const _ip: string = "http://localhost:8080"

export async function _isLoggedIn(secret: string) {
    axios.post(_ip + "/api/frontend/isLoggedIn", { secret: secret })
        .then((res) => {
            return res.data
        })
        .catch((err) => {
            return false
        })
}

export function _isStudent(secret: string) {
    return _getRole(secret) == "STUDENT";
}

export function _isTeacher(secret: string) {
    return _getRole(secret) == "TEACHER";
}

export function _isAdmin(secret: string) {
    return _getRole(secret) == "ADMIN";
}

function _getRole(secret: string): string {
    try {
        axios.post(_ip + "/api/frontend/getRole", { secret: secret })
            .then((res) => {
                return res.data
            })
    } catch (err) {
        return "ERROR"
    }

    return "NULL";
}
 
