import Database from 'better-sqlite3';

/** @type {import('./$types').RequestHandler} */
export async function PUT({ request }) {
    const values = await request.formData();

    const usec: string = values.get("usec") as string;
    const csec: string = values.get("csec") as string;

    const db = new Database("./test.db", { verbose: console.log });
    db.pragma('journal_mode = WAL');

    const makeTable = db.prepare(`CREATE TABLE IF NOT EXISTS user ("usec" TEXT UNIQUE, "csec" TEXT, PRIMARY KEY("csec"))`);
    makeTable.run();

    console.log("\n==========================================\nUser secret received: \n", usec)

    console.log("\n==========================================\ncsec: \n", csec)

    const insert = db.prepare('INSERT OR REPLACE INTO user (csec, usec) VALUES (@csec, @usec)');
    insert.run({usec: usec, csec: csec});

    console.log("\n==========================================\nUser secret saved: \n", usec)

    return new Response('hello from sveltekit!');
}

