import type { PageServerLoad } from '../../management_course/$types';
import { redirect } from '@sveltejs/kit';
import Database from 'better-sqlite3';

let _redirect: boolean = true;

export const load = (async ({ cookies }) => {
    const csec = cookies.get('csec');

    if (csec == undefined && _redirect) {
        cookies.set("redirected", true, { path: '/' })
        throw redirect(307, '/');
    }

    const db = new Database("./test.db", { verbose: console.log });
    db.pragma('journal_mode = WAL');
    let row
    try {
        console.log("polling db for " + csec + "\n")
        const stmt = db.prepare('SELECT csec, usec FROM user WHERE csec = ?');
        row = stmt.get(csec);
    } catch (e) {
        console.log("usec not found\n")
        row = undefined;
        if (_redirect) {
            cookies.set("redirected", true, { path: '/' })
            throw redirect(307, '/');
        }
    }

    return {
        csec, usec: row?.usec
    };
}) satisfies PageServerLoad;

