/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.controller;

import nl.tudelft.ewi.queue.dto.view.RoomMapPathDTO;
import nl.tudelft.ewi.queue.model.Room;
import nl.tudelft.ewi.queue.repository.RoomRepository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * Controller for getting the information of a Room and its map.
 */
@Controller
public class RoomController {
	@Autowired
	private RoomRepository roomRepository;

	/**
	 * Gets the path to the map file of this Room. This is used for rendering an image of the Room in the
	 * page.
	 *
	 * @param  id The ID of the room to find.
	 * @return    A RoomMapPathDTO object representing just the path or null.
	 */
	@GetMapping("/room/map/{id}")
	@PreAuthorize("@permissionService.canViewRoomLayout(principal, #id)")
	public @ResponseBody RoomMapPathDTO getMapFilePath(@PathVariable("id") Long id) {
		Room room = roomRepository.findByIdOrThrow(id);
		return new RoomMapPathDTO(room.getMapFilePath());
	}
}
