/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.controller;

import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping("/saml")
@Profile("production")
public class SSOController {

	private static final Logger logger = LoggerFactory.getLogger(SSOController.class);

	@Autowired
	private MetadataManager metadata;

	@RequestMapping(value = "/idpSelection", method = RequestMethod.GET)
	public String idpSelection(HttpServletRequest request, Model model) {
		if (!(SecurityContextHolder.getContext()
				.getAuthentication() instanceof AnonymousAuthenticationToken)) {
			logger.warn("The current user is already logged.");
			return "redirect:/";
		}

		if (isForwarded(request)) {
			Set<String> idps = metadata.getIDPEntityNames();
			for (String idp : idps) {
				logger.info("Configured Identity Provider for SSO: " + idp);
			}
			model.addAttribute("idps", idps);
			return "saml/idpselection";
		}

		logger.warn("Direct accesses to '/idpSelection' route are not allowed");
		return "redirect:/";
	}

	/*
	 * Checks if an HTTP request is forwarded from servlet.
	 */
	private boolean isForwarded(HttpServletRequest request) {
		return request.getAttribute("javax.servlet.forward.request_uri") != null;
	}
}
