/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.csv;

import java.io.IOException;
import java.util.List;
import java.util.Objects;

import org.springframework.web.multipart.MultipartFile;

import com.fasterxml.jackson.dataformat.csv.CsvSchema;

public class BrightspaceCsvHelper {

	private Integer studentNumber;

	private String netId;

	private String firstName;

	private String lastName;

	private String email;

	private String groupCategory;

	private String groupName;

	private static final CsvSchema schema = CsvSchema.builder()
			.setSkipFirstDataRow(true)
			.addColumn("studentNumber")
			.addColumn("netId")
			.addColumn("firstName")
			.addColumn("lastName")
			.addColumn("email")
			.addColumn("groupCategory")
			.addColumn("groupName")
			.setColumnSeparator(',')
			.build();

	public BrightspaceCsvHelper(Integer studentNumber, String netId, String firstName,
			String lastName, String email, String groupCategory, String groupName) {
		this.studentNumber = studentNumber;
		this.netId = netId;
		this.firstName = firstName;
		this.lastName = lastName;
		this.email = email;
		this.groupCategory = groupCategory;
		this.groupName = groupName;
	}

	public BrightspaceCsvHelper() {
	}

	public Integer getStudentNumber() {
		return studentNumber;
	}

	public void setStudentNumber(Integer studentNumber) {
		this.studentNumber = studentNumber;
	}

	public String getNetId() {
		return netId;
	}

	public void setNetId(String netId) {
		this.netId = netId;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getGroupCategory() {
		return groupCategory;
	}

	public void setGroupCategory(String groupCategory) {
		this.groupCategory = groupCategory;
	}

	/***
	 * Reads a csv file and returns a list of objects matching the csv content.
	 *
	 * @param  csvFile
	 * @return                     A list with BrightspaceCsvHelper objects matching the lines in the csv
	 *                             file.
	 * @throws IOException
	 * @throws EmptyCsvException   if the file is empty.
	 * @throws InvalidCsvException if the csv is invalid (eg: too many delimiters).
	 */
	public static List<BrightspaceCsvHelper> readCsv(MultipartFile csvFile)
			throws IOException, EmptyCsvException, InvalidCsvException {

		return CsvHelper.readCsv(csvFile, BrightspaceCsvHelper.class, schema);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (!(o instanceof BrightspaceCsvHelper))
			return false;
		BrightspaceCsvHelper that = (BrightspaceCsvHelper) o;
		return Objects.equals(studentNumber, that.studentNumber) &&
				Objects.equals(netId, that.netId) &&
				Objects.equals(firstName, that.firstName) &&
				Objects.equals(lastName, that.lastName) &&
				Objects.equals(email, that.email) &&
				Objects.equals(groupCategory, that.groupCategory) &&
				Objects.equals(groupName, that.groupName);
	}

	@Override
	public int hashCode() {
		return Objects.hash(studentNumber, netId, firstName, lastName, email, groupCategory, groupName);
	}

}
