/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.csv;

import java.io.IOException;
import java.util.List;

import lombok.Data;

import org.springframework.web.multipart.MultipartFile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;

@Data
public class FirstYearStudentCsvHelper {
	private static final CsvSchema schema = CsvSchema.builder()
			.setSkipFirstDataRow(true)
			.addColumn("netId")
			.addColumn("mentorGroup")
			.setColumnSeparator(',')
			.build();

	private final String netId;
	private final String mentorGroup;

	@JsonCreator
	public FirstYearStudentCsvHelper(
			@JsonProperty("netId") String netId,
			@JsonProperty("mentorGroup") String mentorGroup) {
		this.netId = netId;
		this.mentorGroup = mentorGroup;
	}

	/***
	 * Reads a csv file and parses it using jackson and returns a list of objects containing the csv content.
	 *
	 * @param  csvFile             The CSV file to read.
	 * @return                     A list of FirstYearStudent objects.
	 * @throws IOException
	 * @throws EmptyCsvException   if the csv file is empty.
	 * @throws InvalidCsvException if the csv is invalid
	 */
	public static List<FirstYearStudentCsvHelper> readCsv(MultipartFile csvFile)
			throws IOException, EmptyCsvException, InvalidCsvException {
		return CsvHelper.readCsv(csvFile, FirstYearStudentCsvHelper.class, schema);
	}
}
