/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.dialect;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.expression.IExpressionObjectFactory;

import com.google.common.collect.Sets;

public class RequestExpressionObjectFactory implements IExpressionObjectFactory {

	private static final String REQUEST_OBJECT_NAME = "request";

	@Override
	public Set<String> getAllExpressionObjectNames() {
		return Sets.newHashSet(REQUEST_OBJECT_NAME);
	}

	@Override
	public Object buildObject(IExpressionContext context, String expressionObjectName) {
		if (REQUEST_OBJECT_NAME.equals(expressionObjectName)) {
			HttpServletRequest httpServletRequest = ((ServletRequestAttributes) RequestContextHolder
					.currentRequestAttributes()).getRequest();
			return new Request(httpServletRequest);
		}
		return null;
	}

	@Override
	public boolean isCacheable(String expressionObjectName) {
		return false;
	}

	private class Request {
		private HttpServletRequest request;

		public Request(HttpServletRequest request) {
			this.request = request;
		}

		public boolean is(String part) {
			Pattern pattern = Pattern.compile(part);
			Matcher matcher = pattern.matcher(request.getRequestURI());

			return matcher.matches();
		}
	}
}
